#exec OBJ LOAD FILE=ZSiriusSkins.utx

class HUDSirius extends HUDCDeathMatch;

var() DigitSet DigitSirius;

// RechargeBar 2
var() SpriteWidget  WeaponIcon[2];
var() SpriteWidget  RechargeBar2;
var() SpriteWidget  StatusDisplay;

function DisplayHit(vector HitDir, int Damage, class<DamageType> damageType)
{
	local int i;
	local vector X,Y,Z;
	local byte Ignore[4];
	local rotator LookDir;
	local float NewDamageTime,Forward,Left;

	LookDir = PawnOwner.Rotation;
	LookDir.Pitch = 0;
	GetAxes(LookDir, X,Y,Z);
	HitDir.Z = 0;
	HitDir = Normal(HitDir);

	Forward = HitDir Dot X;
	Left = HitDir Dot Y;

	if ( Forward > 0 )
	{
		if ( Forward > 0.7 )
			Emphasized[0] = 1;
		Ignore[1] = 1;
	}
	else
	{
		if ( Forward < -0.7 )
			Emphasized[1] = 1;
		Ignore[0] = 1;
	}
	if ( Left > 0 )
	{
		if ( Left > 0.7 )
			Emphasized[3] = 1;
		Ignore[2] = 1;
	}
	else
	{
		if ( Left < -0.7 )
			Emphasized[2] = 1;
		Ignore[3] = 1;
	}

	NewDamageTime = 5 * Clamp(Damage,20,30);
	for ( i=0; i<4; i++ )
		if ( Ignore[i] != 1 )
		{
			DamageFlash[i].G = 127;
			DamageFlash[i].B = 255;
			DamageTime[i] = NewDamageTime;
		}
}

simulated function DrawWeaponBar( Canvas C )
{
}

simulated function DrawAdrenaline( Canvas C )
{
}

simulated function UpdateRankAndSpread(Canvas C)
{
}

simulated function DrawTimer(Canvas C)
{
}

simulated function DrawChargeBar( Canvas C)
{
	local float ScaleFactor;

	ScaleFactor = HUDScale * 0.135 * C.ClipX;
	C.Style = ERenderStyle.STY_Alpha;
	if ( (PawnOwner.PlayerReplicationInfo == None) || (PawnOwner.PlayerReplicationInfo.Team == None)
		|| (PawnOwner.PlayerReplicationInfo.Team.TeamIndex == 1) )
		C.DrawColor = HudColorBlue;
	else
		C.DrawColor = HudColorRed;

	//C.SetPos(C.ClipX - ScaleFactor - 0.0011*HUDScale*C.ClipX, (1 - 0.0975*HUDScale)*C.ClipY);
	//C.DrawTile( Material'HudContent.HUD', ScaleFactor, 0.223*ScaleFactor, 0, 110, 166, 53 );
	
	DrawSpriteWidget( C, WeaponIcon[0] );
	DrawSpriteWidget( C, WeaponIcon[1] );

    RechargeBar.Scale = PawnOwner.Weapon.ChargeBar();
    RechargeBar2.Scale = FreezeRay(PawnOwner.Weapon).ChargeBar2();
	if ( RechargeBar.Scale > 0 && RechargeBar.Scale < 1)
	{
		WeaponIcon[0].WidgetTexture=Material'ZSiriusSkins.HUD.SiriusHUDPulse';
		DrawSpriteWidget( C, RechargeBar );
		//ShowReloadingPulse(RechargeBar.Scale);
	}
	else if(RechargeBar.Scale >= 1)
	{
		WeaponIcon[0].WidgetTexture=default.WeaponIcon[0].WidgetTexture;
	}
	if ( RechargeBar2.Scale > 0 && RechargeBar2.Scale < 1)
	{
		WeaponIcon[1].WidgetTexture=Material'ZSiriusSkins.HUD.SiriusHUDPulse';
		DrawSpriteWidget( C, RechargeBar2 );
		//ShowReloadingPulse(RechargeBar.Scale);
	}
	else if(RechargeBar2.Scale >= 1)
	{
		WeaponIcon[1].WidgetTexture=default.WeaponIcon[1].WidgetTexture;
	}
}

simulated function DrawSpectatingHud (Canvas C)
{
	local string InfoString;
    local plane OldModulate;
    local float xl,yl,Full, Height, Top, TextTop, MedH, SmallH,Scale;
    local GameReplicationInfo GRI;

	// Hack for tutorials.
	bIsCinematic = IsInCinematic();

    DisplayLocalMessages (C);
 
	if ( bIsCinematic )
		return;
		
    OldModulate = C.ColorModulate;

    C.Font = GetMediumFontFor(C);
    C.StrLen("W",xl,MedH);
	Height = MedH;
	C.Font = GetConsoleFont(C);
    C.StrLen("W",xl,SmallH);
    Height += SmallH;

	Full = Height;
    Top  = C.ClipY-8-Full;

	Scale = (Full+16)/128;

	// I like Yellow

    C.ColorModulate.X=255;
    C.ColorModulate.Y=255;
    C.ColorModulate.Z=0;
    C.ColorModulate.W=255;

	// Draw Border

	C.SetPos(0,Top);
    C.SetDrawColor(255,255,255,255);
    C.DrawTileStretched(material'InterfaceContent.SquareBoxA',C.ClipX,Full);
    C.ColorModulate.Z=255;

    TextTop = Top + 4;
    GRI = PlayerOwner.GameReplicationInfo;

    C.SetPos(0,Top-8);
    C.Style=5;
    C.DrawTile(material'LMSLogoSmall',256*Scale,128*Scale,0,0,256,128);
    C.Style=1;

	if ( UnrealPlayer(Owner).bDisplayWinner ||  UnrealPlayer(Owner).bDisplayLoser )
	{
		if ( Sirius(Level.Game).bGoalReached )
			InfoString = YouveWonTheMatch;
		else
		{
			InfoString = YouveLostTheMatch;
		}

        C.SetDrawColor(255,255,255,255);
        C.Font = GetMediumFontFor(C);
        C.StrLen(InfoString,XL,YL);
        C.SetPos( (C.ClipX/2) - (XL/2), Top + (Full/2) - (YL/2));
        C.DrawText(InfoString,false);
    }

	else if ( Pawn(PlayerOwner.ViewTarget) != None && Pawn(PlayerOwner.ViewTarget).PlayerReplicationInfo != None )
    {
    	// Draw View Target info

		C.SetDrawColor(32,255,32,255);

		if ( C.ClipX < 640 )
			SmallH = 0;
		else
		{
			// Draw "Now Viewing"

			C.SetPos((256*Scale*0.75),TextTop);
			C.DrawText(NowViewing,false);

    		// Draw "Score"

			InfoString = GetScoreText();
			C.StrLen(InfoString,Xl,Yl);
			C.SetPos(C.ClipX-5-XL,TextTop);
			C.DrawText(InfoString);
		}

        // Draw Player Name

        C.SetDrawColor(255,255,0,255);
        C.Font = GetMediumFontFor(C);
        C.SetPos((256*Scale*0.75),TextTop+SmallH);
        C.DrawText(Pawn(PlayerOwner.ViewTarget).PlayerReplicationInfo.PlayerName,false);

        // Draw Score

	    InfoString = GetScoreValue(Pawn(PlayerOwner.ViewTarget).PlayerReplicationInfo);
	    C.StrLen(InfoString,xl,yl);
	    C.SetPos(C.ClipX-5-XL,TextTop+SmallH);
	    C.DrawText(InfoString,false);

        // Draw Tag Line

	    C.Font = GetConsoleFont(C);
	    InfoString = GetScoreTagLine();
	    C.StrLen(InfoString,xl,yl);
	    C.SetPos( (C.ClipX/2) - (XL/2),Top-3-YL);
	    C.DrawText(InfoString);
    }
    else
    {
		InfoString = GetInfoString();

    	// Draw
    	C.SetDrawColor(255,255,255,255);
        C.Font = GetMediumFontFor(C);
        C.StrLen(InfoString,XL,YL);
        C.SetPos( (C.ClipX/2) - (XL/2), Top + (Full/2) - (YL/2));
        C.DrawText(InfoString,false);
    }

    C.ColorModulate = OldModulate;

}

simulated function DrawHudPassA (Canvas C)
{
	local Pawn RealPawnOwner;
//	local class<Ammunition> AmmoClass;

	ZoomFadeOut(C);

	if ( PawnOwner != None )
	{
//		if( bShowWeaponInfo && (PawnOwner.Weapon != None) )
//		{
			DrawSpriteWidget(C, StatusDisplay);
			if ( PawnOwner.Weapon != None && PawnOwner.Weapon.bShowChargingBar )
    			DrawChargeBar(C);
//
//			DrawSpriteWidget( C, HudBorderAmmo );
//
//			if( PawnOwner.Weapon != None )
//			{
//				AmmoClass = PawnOwner.Weapon.GetAmmoClass(0);
//				if ( (AmmoClass != None) && (AmmoClass.Default.IconMaterial != None) )
//				{
//					if( (CurAmmoPrimary/MaxAmmoPrimary) < 0.15)
//					{
//						DrawSpriteWidget(C, HudAmmoALERT);
//						HudAmmoALERT.Tints[TeamIndex] = HudColorTeam[TeamIndex];
//						if ( AmmoClass.Default.IconFlashMaterial == None )
//							AmmoIcon.WidgetTexture = Material'HudContent.Generic.HUDPulse';
//						else
//							AmmoIcon.WidgetTexture = AmmoClass.Default.IconFlashMaterial;
//					}
//					else
//					{
//						AmmoIcon.WidgetTexture = AmmoClass.default.IconMaterial;
//					}
//
//					AmmoIcon.TextureCoords = AmmoClass.Default.IconCoords;
//					DrawSpriteWidget (C, AmmoIcon);
//				}
//			}
//			DrawNumericWidget( C, DigitsAmmo, DigitsBig);
//		}

		if ( bShowWeaponBar && (PawnOwner.Weapon != None) )
			DrawWeaponBar(C);

		if( bShowPersonalInfo )
		{
    		if ( Vehicle(PawnOwner) != None && Vehicle(PawnOwner).Driver != None )
    		{
    			if (Vehicle(PawnOwner).bShowChargingBar)
    				DrawVehicleChargeBar(C);
    			RealPawnOwner = PawnOwner;
    			PawnOwner = Vehicle(PawnOwner).Driver;
    		}

			DrawHUDAnimWidget( HudBorderHealthIcon, default.HudBorderHealthIcon.TextureScale, LastHealthPickupTime, 0.6, 0.6);
			//DrawSpriteWidget( C, HudBorderHealth );

			if(CurHealth/PawnOwner.HealthMax < 0.26)
			{
//				HudHealthALERT.Tints[TeamIndex] = HudColorTeam[TeamIndex];
//				DrawSpriteWidget( C, HudHealthALERT);
				HudBorderHealthIcon.WidgetTexture = Material'ZSiriusSkins.HUD.SiriusHUDPulse';
			}
			else
				HudBorderHealthIcon.WidgetTexture = default.HudBorderHealthIcon.WidgetTexture;

			DrawSpriteWidget( C, HudBorderHealthIcon);

			if( CurHealth < LastHealth )
				LastDamagedHealth = Level.TimeSeconds;

			DrawHUDAnimDigit( DigitsHealth, default.DigitsHealth.TextureScale, LastDamagedHealth, 0.8, default.DigitsHealth.Tints[TeamIndex], HudColorHighLight);
			DrawNumericWidget( C, DigitsHealth, DigitSirius);

			if(CurHealth > 999)
			{
				DigitsHealth.OffsetX=220;
				DigitsHealth.OffsetY=-35;
				DigitsHealth.TextureScale=0.39;
			}
			else
			{
				DigitsHealth.OffsetX = default.DigitsHealth.OffsetX;
				DigitsHealth.OffsetY = default.DigitsHealth.OffsetY;
				DigitsHealth.TextureScale = default.DigitsHealth.TextureScale;
			}

			if (RealPawnOwner != None)
			{
				PawnOwner = RealPawnOwner;

				DrawSpriteWidget( C, HudBorderVehicleHealth );

				if (CurVehicleHealth/PawnOwner.HealthMax < 0.26)
				{
					HudVehicleHealthALERT.Tints[TeamIndex] = HudColorTeam[TeamIndex];
					DrawSpriteWidget(C, HudVehicleHealthALERT);
					HudBorderVehicleHealthIcon.WidgetTexture = Material'HudContent.Generic.HUDPulse';
				}
				else
					HudBorderVehicleHealthIcon.WidgetTexture = default.HudBorderVehicleHealth.WidgetTexture;

				DrawSpriteWidget(C, HudBorderVehicleHealthIcon);

				if (CurVehicleHealth < LastVehicleHealth )
					LastDamagedVehicleHealth = Level.TimeSeconds;

				DrawHUDAnimDigit(DigitsVehicleHealth, default.DigitsVehicleHealth.TextureScale, LastDamagedVehicleHealth, 0.8, default.DigitsVehicleHealth.Tints[TeamIndex], HudColorHighLight);
				DrawNumericWidget(C, DigitsVehicleHealth, DigitsBig);

				if (CurVehicleHealth > 999)
				{
					DigitsVehicleHealth.OffsetX = 220;
					DigitsVehicleHealth.OffsetY = -35;
					DigitsVehicleHealth.TextureScale = 0.39;
				}
				else
				{
					DigitsVehicleHealth.OffsetX = default.DigitsVehicleHealth.OffsetX;
					DigitsVehicleHealth.OffsetY = default.DigitsVehicleHealth.OffsetY;
					DigitsVehicleHealth.TextureScale = default.DigitsVehicleHealth.TextureScale;
				}
			}

			DrawAdrenaline(C);
		}
	}

	UpdateRankAndSpread(C);
    DrawUDamage(C);

    if(bDrawTimer)
		DrawTimer(C);

    // Temp Drawwwith Hud Colors
    HudBorderShield.Tints[0] = HudColorRed;
    HudBorderShield.Tints[1] = HudColorBlue;
    HudBorderHealth.Tints[0] = HudColorRed;
    HudBorderHealth.Tints[1] = HudColorBlue;
    HudBorderVehicleHealth.Tints[0] = HudColorRed;
    HudBorderVehicleHealth.Tints[1] = HudColorBlue;
    HudBorderAmmo.Tints[0] = HudColorRed;
    HudBorderAmmo.Tints[1] = HudColorBlue;

    if( bShowPersonalInfo && (CurShield > 0) )
    {
	    DrawSpriteWidget( C, HudBorderShield );
		DrawSpriteWidget( C, HudBorderShieldIcon);
		DrawNumericWidget( C, DigitsShield, DigitsBig);
		DrawHUDAnimWidget( HudBorderShieldIcon, default.HudBorderShieldIcon.TextureScale, LastArmorPickupTime, 0.6, 0.6);
    }

	if( Level.TimeSeconds - LastVoiceGainTime < 0.333 )
		DisplayVoiceGain(C);

    DisplayLocalMessages (C);
}

simulated function DrawHudPassC (Canvas C)
{
	local VoiceChatRoom VCR;
	local float PortraitWidth,PortraitHeight, X, Y, XL, YL, Abbrev, SmallH, NameWidth;
	local string PortraitString;

	// portrait
	if ( (bShowPortrait || (bShowPortraitVC && Level.TimeSeconds - LastPlayerIDTalkingTime < 2.0)) && (Portrait != None) )
	{
		PortraitWidth = 0.125 * C.ClipY;
		PortraitHeight = 1.5 * PortraitWidth;
		C.DrawColor = WhiteColor;

		C.SetPos(-PortraitWidth*PortraitX + 0.025*PortraitWidth,0.5*(C.ClipY-PortraitHeight) + 0.025*PortraitHeight);
		C.DrawTile( Portrait, PortraitWidth, PortraitHeight, 0, 0, 256, 384);

		C.SetPos(-PortraitWidth*PortraitX,0.5*(C.ClipY-PortraitHeight));
		C.Font = GetFontSizeIndex(C,-2);
		
		if ( PortraitPRI != None )
		{
			PortraitString = PortraitPRI.PlayerName;
			C.StrLen(PortraitString,XL,YL);
			if ( XL > PortraitWidth )
			{
				C.Font = GetFontSizeIndex(C,-4);
				C.StrLen(PortraitString,XL,YL);
				if ( XL > PortraitWidth )
				{
					Abbrev = float(len(PortraitString)) * PortraitWidth/XL;
					PortraitString = left(PortraitString,Abbrev);
					C.StrLen(PortraitString,XL,YL);
				}
			}
		}
		C.DrawColor = C.static.MakeColor(160,160,160);
		C.SetPos(-PortraitWidth*PortraitX + 0.025*PortraitWidth,0.5*(C.ClipY-PortraitHeight) + 0.025*PortraitHeight);
		C.DrawTile( Material'XGameShaders.ModuNoise', PortraitWidth, PortraitHeight, 0.0, 0.0, 512, 512 );

		C.DrawColor = WhiteColor;
		C.SetPos(-PortraitWidth*PortraitX,0.5*(C.ClipY-PortraitHeight));
		C.DrawTileStretched(texture 'InterfaceContent.Menu.BorderBoxA1', 1.05 * PortraitWidth, 1.05*PortraitHeight);

		C.DrawColor = WhiteColor;

		X = C.ClipY/256-PortraitWidth*PortraitX;
		Y = 0.5*(C.ClipY+PortraitHeight) + 0.06*PortraitHeight;
		C.SetPos( X + 0.5 * (PortraitWidth - XL), Y );

		if ( PortraitPRI != None )
		{
			if ( PortraitPRI.Team != None )
			{
				if ( PortraitPRI.Team.TeamIndex == 0 )
					C.DrawColor = RedColor;
				else
					C.DrawColor = TurqColor;
			}

			C.DrawText(PortraitString,true);

			if ( Level.TimeSeconds - LastPlayerIDTalkingTime < 2.0
				&& PortraitPRI.ActiveChannel != -1
				&& PlayerOwner.VoiceReplicationInfo != None )
			{
				VCR = PlayerOwner.VoiceReplicationInfo.GetChannelAt(PortraitPRI.ActiveChannel);
				if ( VCR != None )
				{
					PortraitString = "(" @ VCR.GetTitle() @ ")";
					C.StrLen( PortraitString, XL, YL );
					if ( PortraitX == 0 )
						C.SetPos( Max(0, X + 0.5 * (PortraitWidth - XL)), Y + YL );
					else C.SetPos( X + 0.5 * (PortraitWidth - XL), Y + YL );
					C.DrawText( PortraitString );
				}
			}
		}
	}

//    if( bShowWeaponInfo && (PawnOwner != None) && (PawnOwner.Weapon != None) )
//		PawnOwner.Weapon.NewDrawWeaponInfo(C, 0.86 * C.ClipY);

	if ( (PawnOwner != PlayerOwner.Pawn) && (PawnOwner != None)
		&& (PawnOwner.PlayerReplicationInfo != None) )
	{
		// draw viewed player name
	    C.Font = GetMediumFontFor(C);
        C.SetDrawColor(255,255,0,255);
		C.StrLen(PawnOwner.PlayerReplicationInfo.PlayerName,NameWidth,SmallH);
		NameWidth = FMax(NameWidth, 0.15 * C.ClipX);
		if ( C.ClipX >= 640 )
		{
			C.Font = GetConsoleFont(C);
			C.StrLen("W",XL,SmallH);
			C.SetPos(79*C.ClipX/80 - NameWidth,C.ClipY * 0.68);
			C.DrawText(NowViewing,false);
		}

        C.Font = GetMediumFontFor(C);
        C.SetPos(79*C.ClipX/80 - NameWidth,C.ClipY * 0.68 + SmallH);
        C.DrawText(PawnOwner.PlayerReplicationInfo.PlayerName,false);
	}

     DrawCrosshair(C);
}

defaultproperties
{
	DigitSirius=(DigitTexture=Texture'ZSiriusSkins.HUD.SiriusHUD',TextureCoords[0]=(X1=1,X2=25,Y1=231,Y2=280),TextureCoords[1]=(X1=26,X2=50,Y1=231,Y2=280),TextureCoords[2]=(X1=51,X2=75,Y1=231,Y2=280),TextureCoords[3]=(X1=76,X2=100,Y1=231,Y2=280),TextureCoords[4]=(X1=101,X2=125,Y1=231,Y2=280),TextureCoords[5]=(X1=126,X2=150,Y1=231,Y2=280),TextureCoords[6]=(X1=151,X2=175,Y1=231,Y2=280),TextureCoords[7]=(X1=176,X2=200,Y1=231,Y2=280),TextureCoords[8]=(X1=201,X2=225,Y1=231,Y2=280),TextureCoords[9]=(X1=226,X2=250,Y1=231,Y2=280),TextureCoords[10]=(X1=251,X2=275,Y1=231,Y2=280))
	DigitsHealth=(RenderStyle=STY_Alpha,TextureScale=0.500000,DrawPivot=DP_LowerRight,PosX=1.000000,PosY=1.000000,OffsetX=-2,OffsetY=-2,Tints[0]=(B=255,G=255,R=255,A=255),Tints[1]=(B=255,G=255,R=255,A=255))
	YouveWonTheMatch="Mission Accomplished!"
	YouveLostTheMatch="Mission Failed!"
	HudColorBlue=(B=255,G=255,R=255,A=255)
	HudColorTeam(0)=(B=255,G=255,R=255,A=255)
	HudColorTeam(1)=(B=255,G=255,R=255,A=255)
	HudBorderHealthIcon=(WidgetTexture=Texture'ZSiriusSkins.HUD.SiriusHUD',RenderStyle=STY_Alpha,TextureCoords=(X1=101,Y1=1,X2=140,Y2=50),TextureScale=0.500000,DrawPivot=DP_LowerRight,PosX=1.000000,PosY=1.000000,OffsetX=-37,OffsetY=-55,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(B=255,G=255,R=255,A=200),Tints[1]=(B=255,G=255,R=255,A=200))
	WeaponIcon(0)=(WidgetTexture=Texture'ZSiriusSkins.HUD.SiriusHUD',RenderStyle=STY_Alpha,TextureCoords=(X1=1,Y1=1,X2=50,Y2=50),TextureScale=0.500000,DrawPivot=DP_LowerRight,PosX=1.000000,PosY=1.000000,OffsetX=-82,OffsetY=-55,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(B=255,G=255,R=255,A=200),Tints[1]=(B=255,G=255,R=255,A=200))
	WeaponIcon(1)=(WidgetTexture=Texture'ZSiriusSkins.HUD.SiriusHUD',RenderStyle=STY_Alpha,TextureCoords=(X1=51,Y1=1,X2=100,Y2=50),TextureScale=0.500000,DrawPivot=DP_LowerRight,PosX=1.000000,PosY=1.000000,OffsetX=-82,OffsetY=-2,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(B=255,G=255,R=255,A=200),Tints[1]=(B=255,G=255,R=255,A=200))
	RechargeBar=(WidgetTexture=Texture'ZSiriusSkins.HUD.SiriusHUD',RenderStyle=STY_Alpha,TextureCoords=(X1=141,Y1=1,X2=320,Y2=40),TextureScale=0.500000,DrawPivot=DP_LowerRight,PosX=1.000000,PosY=1.000000,OffsetX=-137,OffsetY=-60,ScaleMode=SM_Left,Scale=1.000000,Tints[0]=(B=255,G=255,R=255,A=220),Tints[1]=(B=255,G=255,R=255,A=220))
	RechargeBar2=(WidgetTexture=Texture'ZSiriusSkins.HUD.SiriusHUD',RenderStyle=STY_Alpha,TextureCoords=(X1=141,Y1=41,X2=320,Y2=80),TextureScale=0.500000,DrawPivot=DP_LowerRight,PosX=1.000000,PosY=1.000000,OffsetX=-137,OffsetY=-7,ScaleMode=SM_Left,Scale=1.000000,Tints[0]=(B=255,G=255,R=255,A=220),Tints[1]=(B=255,G=255,R=255,A=220))
	StatusDisplay=(WidgetTexture=Texture'ZSiriusSkins.HUD.SiriusHUD',RenderStyle=STY_Alpha,TextureCoords=(X1=1,Y1=81,X2=400,Y2=230),TextureScale=0.500000,DrawPivot=DP_LowerRight,PosX=1.000000,PosY=1.000000,OffsetX=0,OffsetY=0,ScaleMode=SM_Left,Scale=1.000000,Tints[0]=(B=255,G=255,R=255,A=220),Tints[1]=(B=255,G=255,R=255,A=220))
}